<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SkuMaster extends Model
{
    protected $table = 'skumaster';

    protected $fillable = [
        'item_name',
        'category',
        'uom',
        'tax_rate',
        'current_stock',
        'default_price',
        'discount_price',
        'tcs',
        'min_order_level',
        'max_order_level',
        'hsn_code',
        'supplier_name',
        'supplier_phone',
        'supplier_email',
        'reason'
    ];
    
    public function sku()
{
    return $this->belongsTo(\App\Models\SkuMaster::class, 'sku_id');
}
}
