<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QualityControl extends Model
{
    use HasFactory;

    // The table associated with the model.
    protected $table = 'quality_controls'; // Adjust the table name as needed

    // The attributes that are mass assignable.
    protected $fillable = [
        'customer',
        'project_no',
        'material_no',
        'part_no',
        'drawing_certification',
        'document_type',
        'document_value',
        'revision',
        'sl_no',
        'drawing_position',
        'parameter',
        'description',
        'drawing_value',
        'tolerance',
        'measurement_value1',
        'measurement_value2',
        'remarks',
        'status',
    ];

    // Optionally, if you need to add some custom timestamps or time fields, you can modify this.
    // public $timestamps = true;

    // Relationship methods, if necessary, can go here.
    // For example, if QualityControl has many related records:
    // public function relatedRecords()
    // {
    //     return $this->hasMany(RelatedRecord::class);
    // }
}
