<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MachineLog extends Model
{
    use HasFactory;

    protected $table = 'machine_logs';

    protected $fillable = [
        'machine_id',
        'reason',
        'start_time',
        'end_time',
        'reported_by'
    ];

    public function machine()
    {
        return $this->belongsTo(Machines::class, 'machine_id');
    }

    public function reporter()
    {
        return $this->belongsTo(EmployeeDetails::class, 'reported_by');
    }
}
