<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GrnOrder extends Model
{
    use HasFactory;

    protected $table = 'grn_orders';

    protected $fillable = [
        'grn_no',
        'grn_date',
        'order_no',
        'order_date',
        'company_name',
        'order_ref_no',
        'company_address',
        'company_gstn',
        'company_email',
        'company_phone',
        'quotation_no',
        'quotation_date',
        'rfq_no',
        'rfq_date',
        'part_no',
        'project_material_no',
        'drawing_no',
        'drawing_rev',
        'description',
        'product_type',
        'challan_path', // store uploaded file path
        'total_amount',
        'sgst_amount',
        'cgst_amount',
        'igst_amount',
        'roundup_amount',
        'grand_total',
    ];

    protected $casts = [
        'grn_date' => 'date',
        'order_date' => 'date',
        'quotation_date' => 'date',
        'rfq_date' => 'date',
    ];

    public function grnItems()
    {
        return $this->hasMany(GrnItem::class);
    }
}
