<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeSalaryStructure extends Model
{
    use HasFactory;

    protected $fillable = [
        'employee_id',
        'basic_da',
        'hra',
        'conveyance',
        'washing_allowance',
        'fixed_salary',
        'pf_percentage',
        'esi_percentage', // Optional: if you want to store specific rates per employee
    ];

    public function employee()
    {
        return $this->belongsTo(EmployeeDetails::class, 'employee_id');
    }
}
