<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeePayroll extends Model
{
    use HasFactory;

    protected $table = 'employee_payrolls';

    protected $fillable = [
        'employee_id',
        'employee_name',
        'month_year',
        'basic_da',
        'hra',
        'conveyance',
        'washing_allowance',
        'fixed_salary',
        'days_worked',
        'leave_given',
        'total_days',
        'drawn_salary',
        'incentive_hrs',
        'incentive_rate',
        'incentive_amount',
        'attendance_bonus',
        'gross_salary',
        'esi',
        'pf',
        'pt',
        'advance_deduction',
        'net_salary',
        'pay_mode'
    ];

    protected $casts = [
        'month_year' => 'date:Y-m',
    ];
}
