<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomerVendor extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_role', 'company', 'email', 'company_nickname', 'image', 'mobile','secondary_mobile', 'company_type',
        'gstno', 'panno', 'msmeno', 'iecno', 'billing_address', 'shipping_address', 'url',
        'bank_name', 'branch_name', 'account_number', 'account_type', 'account_holder_name',
        'account_currency', 'ifsc_code', 'swift_code','status'
    ];

    public function contactPersons()
    {
        return $this->hasMany(ContactPerson::class, 'customer_vendor_id');
    }
    public function rfqs()
{
    return $this->hasMany(PurchaseRfq::class, 'vendor_id', 'id');
}
}
