<?php

namespace App\Imports;

use App\Models\Category;
use App\Models\StockItem;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class StockItemsImport implements ToCollection, WithHeadingRow
{
    public function collection(Collection $rows)
    {
        foreach ($rows as $index => $row) {
            // Skip row if required fields are missing
            if (empty($row['category']) || empty($row['item_name'])) {
                continue;
            }

            $categoryName = trim($row['category']);
            $itemName = trim($row['item_name']);

            // Create or get category
            $category = Category::firstOrCreate(['name' => $categoryName]);

            // Skip if item with same name already exists in this category
            $existing = StockItem::where('item_name', $itemName)
                                 ->where('category_id', $category->id)
                                 ->exists();

            if ($existing) {
                continue; // Skip duplicate
            }

            // Create new stock item
            StockItem::create([
                'item_name'   => $itemName,
                'category_id' => $category->id,
                'uom'         => $row['uom'] ?? null,
                'sgst'        => $row['sgst'] ?? null,
                'cgst'        => $row['cgst'] ?? null,
                'igst'        => $row['igst'] ?? null,
            ]);
        }
    }
}
