<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ManufacturingPlan;
use App\Models\RouteCardProcess;
use App\Models\RouteCard;

class ManufacturingPlanningController extends Controller
{
    public function index()
    {
        return response()->json(ManufacturingPlan::all());
    }

    public function show($id)
    {
        return response()->json(ManufacturingPlan::findOrFail($id));
    }
    public function planPage()
    {
        // You can pass anything to the view if needed, but the page will fetch RC+processes with AJAX
        $operators = \App\Models\EmployeeDetails::pluck('name', 'id')->toArray();
        return view('admin.manufacturing.plan', compact('operators'));
    }

    public function rcProcesses($id)
    {
        // Get RC + processes
        $rc = \App\Models\RouteCard::with('processes')->findOrFail($id);
        return response()->json($rc);
    }

    public function planPageWithId($id)
{
    $operators = \App\Models\EmployeeDetails::pluck('name', 'id')->toArray();
    $routeCard = \App\Models\RouteCard::with('processes')->findOrFail($id);

    // Machine & Operator Availability Logic
    $now = \Carbon\Carbon::now();

    $machines = \App\Models\Machines::all();
    $employees = \App\Models\EmployeeDetails::all();

    $machineAvailability = [];
    foreach ($machines as $machine) {
        $maxEndDate = \DB::table('route_card_processes')
            ->where('machine', $machine->machine_id)
            ->max('end_date');
        if ($maxEndDate && \Carbon\Carbon::parse($maxEndDate)->gt($now)) {
            $availDate = 'Available from: ' . \Carbon\Carbon::parse($maxEndDate)->format('d-m-Y H:i');
        } else {
            $availDate = 'Available now';
        }
        $machineAvailability[$machine->machine_id] = $availDate;
    }

    $operatorAvailability = [];
    foreach ($employees as $emp) {
        $maxEndDate = \DB::table('route_card_processes')
            ->where('operator', $emp->id)
            ->max('end_date');
        if ($maxEndDate && \Carbon\Carbon::parse($maxEndDate)->gt($now)) {
            $availDate = 'Available from: ' . \Carbon\Carbon::parse($maxEndDate)->format('d-m-Y H:i');
        } else {
            $availDate = 'Available now';
        }
        $operatorAvailability[$emp->id] = $availDate;
    }

    return view('admin.manufacturing.plan', compact(
        'operators', 'routeCard', 'id', 'machineAvailability', 'operatorAvailability'
    ));
}



    public function store(Request $request)
    {
        $data = $request->validate([
            'rc_id' => 'required|string',
            'company_name' => 'required|string',
            'status' => 'nullable|string',
            'rc_date' => 'nullable|date',
            'approved_by' => 'nullable|string',
            'plan_by' => 'nullable|string',
            'plan_date' => 'nullable|date',
            'machine' => 'nullable|string',
            'process' => 'nullable|string',
            'operator' => 'nullable|string',
            'ct_hours' => 'nullable|string',
            'ct_minutes' => 'nullable|string',
            'start_date' => 'nullable|date',
            'end_date' => 'nullable|date',
        ]);
        $plan = ManufacturingPlan::create($data);
        return response()->json($plan, 201);
    }

    public function updateProcess(Request $request, $id)
    {
        $process = RouteCardProcess::findOrFail($id);
        $data = $request->validate([
            'description' => 'nullable|string',
            'start_date' => 'nullable|date',
            'end_date' => 'nullable|date',
            'operator' => 'nullable|string',
            'machine' => 'nullable|string',
            'process' => 'nullable|string',
            'cycle_hours' => 'nullable|integer',
            'cycle_minutes' => 'nullable|integer',
            'source' => 'nullable|string',
            'previous_process' => 'nullable|string',
        ]);
        $process->update($data);
        return response()->json(['success' => true, 'process' => $process]);
    }

    public function destroy($id)
    {
        $plan = ManufacturingPlan::findOrFail($id);
        $plan->delete();
        return response()->json(['message' => 'Deleted']);
    }
}
