<?php

namespace App\Console\Commands;

use App\Models\UserActivity;
use Illuminate\Console\Command;

class CleanupUserActivities extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'activities:cleanup {--days=30 : Number of days to keep activities}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Delete user activity records older than specified days (default: 30)';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $days = (int) $this->option('days');

        $this->info("Cleaning up user activities older than {$days} days...");

        $deletedCount = UserActivity::deleteOlderThan($days);

        $this->info("Successfully deleted {$deletedCount} activity records.");

        return Command::SUCCESS;
    }
}
