@extends('layouts.dashboard.superadminapp')

@section('title', 'View Purchase Quotation')

@section('content')
    <style>
        .quotation-view-card {
            background: linear-gradient(120deg, #f6f7f9 0%, #e9ecef 100%);
            border-radius: 1.2rem;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.09);
            overflow: hidden;
            border: none;
        }

        .quotation-header {
            background: linear-gradient(120deg, #84fab0 0%, #8fd3f4 100%);
            padding: 1.5rem 2rem 1rem 2rem;
            color: #222;
            border-top-left-radius: 1.2rem;
            border-top-right-radius: 1.2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .quotation-header h3 {
            margin-bottom: 0;
            font-weight: 700;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .quotation-body {
            background: #fff;
            border-bottom-left-radius: 1.2rem;
            border-bottom-right-radius: 1.2rem;
            padding: 2rem;
        }

        .quotation-label {
            color: #4f4f4f;
            font-weight: 600;
        }

        .quotation-value {
            color: #2b2b2b;
            font-weight: 700;
        }

        .quotation-detail-row {
            margin-bottom: 1rem;
        }

        .quotation-back-btn {
            min-width: 130px;
            border-radius: 2rem;
            font-size: 1.1rem;
            font-weight: 600;
            box-shadow: 0 3px 18px rgba(253, 160, 133, 0.09);
        }

        @media (max-width: 991px) {
            .quotation-body {
                padding: 1.2rem;
            }

            .quotation-header {
                padding: 1rem 1rem 0.7rem 1rem;
            }
        }
    </style>

    <div class="container-fluid">
        <div class="row justify-content-center py-4">
            <div class="col-12 col-lg-10">
                <div class="card quotation-view-card">
                    <div class="quotation-header">
                        <h3><i class="fas fa-file-invoice-dollar"></i> Purchase Quotation Details</h3>
                        <a href="{{ route('superadminv1.purchasequotation.list') }}" class="btn btn-light quotation-back-btn">
                            <i class="fa fa-arrow-left"></i> Back
                        </a>
                    </div>
                    <div class="quotation-body">
                        <div class="row">
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">Quotation No:</span>
                                <div class="quotation-value">{{ $quotation->quotation_no }}</div>
                            </div>
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">Quotation Date:</span>
                                 <div class="quotation-value">{{ formateDate($quotation->quotation_date) }}</div>
                            </div>
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">Vendor Name:</span>
                                <div class="quotation-value">{{ $quotation->vendor_name }}</div>
                            </div>
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">RFQ No:</span>
                                <div class="quotation-value">{{ $quotation->rfq_no }}</div>
                            </div>
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">RFQ Date:</span>
                                <div class="quotation-value">{{ $quotation->rfq_date }}</div>
                            </div>
                             <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">Vendor Reference No:</span>
                                <div class="quotation-value">{{ $quotation->vendor_reference_no }}</div>
                            </div>
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">Additional Charges:</span>
                                <div class="quotation-value">{{ $quotation->additional_charges }}</div>
                            </div>
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">Delivery Terms:</span>
                                <div class="quotation-value">{{ $quotation->delivery_terms }}</div>
                            </div>
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">Address:</span>
                                <div class="quotation-value">{{ $quotation->address }}</div>
                            </div>
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">GST:</span>
                                <div class="quotation-value">{{ $quotation->gst }}</div>
                            </div>
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">Phone:</span>
                                <div class="quotation-value">{{ $quotation->phone }}</div>
                            </div>
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">Email:</span>
                                <div class="quotation-value">{{ $quotation->email }}</div>
                            </div>
                            <!--<div class="col-md-6 quotation-detail-row">-->
                            <!--    <span class="quotation-label">Quantity:</span>-->
                            <!--    <div class="quotation-value">{{ $quotation->quantity }}</div>-->
                            <!--</div>-->
                            <!--<div class="col-md-6 quotation-detail-row">-->
                            <!--    <span class="quotation-label">UOM:</span>-->
                            <!--    <div class="quotation-value">{{ $quotation->quantity_uom }}</div>-->
                            <!--</div>-->
                            <!--<div class="col-md-12 quotation-detail-row">-->
                            <!--    <span class="quotation-label">Description:</span>-->
                            <!--    <div class="quotation-value">{{ $quotation->description }}</div>-->
                            <!--</div>-->
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">Note:</span>
                                <div class="quotation-value">{{ $quotation->note }}</div>
                            </div>
                            <div class="col-md-6 quotation-detail-row">
                                <span class="quotation-label">Status:</span>
                                <div class="quotation-value">{{ $quotation->status }}</div>
                            </div>
                        </div>
                        <h5 class="mb-3"><i class="fas fa-paperclip me-2"></i>Vendor Quotations Attachments</h5>
                        <div class="row">
                            @forelse ($quotation->files as $file)
                                <div class="col-md-4 mb-2">
                                    <a href="{{ asset('storage/' . $file->file_path) }}"
                                       target="_blank"
                                       class="btn btn-info btn-sm mt-1 d-block"
                                       title="{{ $file->file_name }}">
                                       View {{ $file->file_name }}
                                    </a>
                                </div>
                            @empty
                                <div class="col-12">
                                    <p>No vendor quotation files attached.</p>
                                </div>
                            @endforelse
                        </div>


                        <hr class="my-4">

                        <h5 class="mb-3"><i class="fas fa-boxes me-2"></i>Quotation Items</h5>
                        @if ($quotation->items->count())
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Stock Item</th>
                                            <th>Description</th>
                                            <th>Quantity</th>
                                            <th>UOM</th>
                                            <th>Supply Lead Time</th>
                                            <th>Unit Rate</th>
                                            <th>TDS (%)</th>
                                            <th>Discount (%)</th>
                                            <th>Value</th>
                                            <th>SGST (%)</th>
                                            <th>CGST (%)</th>
                                            <th>IGST (%)</th>
                                            <th>Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($quotation->items as $idx => $item)
                                            <tr>
                                                <td>{{ $idx + 1 }}</td>
                                                <td>{{ $item->stockItem ? $item->stockItem->item_name : $item->stock_item }}</td>
                                                <td>{{ $item->description }}</td>
                                                <td>{{ $item->quantity }}</td>
                                                <td>{{ $item->uom }}</td>
                                                <td>{{ $item->supply_lead_time }}</td>
                                                <td>{{ $item->unit_rate }}</td>
                                                <td>{{ $item->tds }}</td>
                                                <td>{{ $item->discount }}</td>
                                                <td>{{ $item->value }}</td>
                                                <td>{{ $item->sgst }}</td>
                                                <td>{{ $item->cgst }}</td>
                                                <td>{{ $item->igst }}</td>
                                                <td>{{ $item->amount }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <p class="text-muted">No items added to this quotation.</p>
                        @endif

                        <hr class="my-4">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="quotation-detail-row">
                                    <span class="quotation-label">Sub Total:</span>
                                    <div class="quotation-value">{{ $quotation->sub_total }}</div>
                                </div>
                                <div class="quotation-detail-row">
                                    <span class="quotation-label">Round Up:</span>
                                    <div class="quotation-value">{{ $quotation->round_up }}</div>
                                </div>
                                <div class="quotation-detail-row">
                                    <span class="quotation-label">Grand Total:</span>
                                    <div class="quotation-value">{{ $quotation->grand_total }}</div>
                                </div>
                                 <div class="quotation-detail-row">
                                    <span class="quotation-label">Amount in Words:</span>
                                    <div class="quotation-value">{{ $quotation->inr_in_words }}</div>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end mt-4">
                            <a href="{{ route('superadminv1.purchasequotation.list') }}" class="btn btn-light quotation-back-btn">
                                <i class="fa fa-arrow-left"></i> Back to List
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection