<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Purchase Order - {{ $purchaseOrder->purchase_order_no }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 12px;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .company-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }
        .purchase-info {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
        }
        .total-section {
            text-align: right;
            margin-top: 20px;
        }
        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 10px;
        }
        @media print {
            body { margin: 0; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>PURCHASE ORDER</h1>
        <p>Purchase Order No: {{ $purchaseOrder->purchase_order_no }}</p>
    </div>

    <div class="company-info">
        <div>
            <h4>Company Details</h4>
            <p><strong>Name:</strong> {{ $purchaseOrder->company_name }}</p>
            <p><strong>Phone:</strong> {{ $purchaseOrder->company_phone }}</p>
            <p><strong>Email:</strong> {{ $purchaseOrder->company_email }}</p>
            <p><strong>GSTN:</strong> {{ $purchaseOrder->company_gstn }}</p>
            <p><strong>Address:</strong> {{ $purchaseOrder->company_address }}</p>
        </div>
        <div>
            <h4>Vendor Details</h4>
            <p><strong>Name:</strong> {{ $purchaseOrder->vendor->name ?? 'N/A' }}</p>
            <p><strong>Phone:</strong> {{ $purchaseOrder->vendor->phone ?? 'N/A' }}</p>
            <p><strong>Email:</strong> {{ $purchaseOrder->vendor->email ?? 'N/A' }}</p>
            <p><strong>Address:</strong> {{ $purchaseOrder->vendor->address ?? 'N/A' }}</p>
        </div>
    </div>

    <div class="purchase-info">
        <div>
            <p><strong>Purchase Order Date:</strong> {{ $purchaseOrder->purchase_order_date }}</p>
            <p><strong>Vendor Ref No:</strong> {{ $purchaseOrder->vendor_ref_no ?? 'N/A' }}</p>
        </div>
        <div>
            <p><strong>Quotation No:</strong> {{ $purchaseOrder->quotation_no ?? 'N/A' }}</p>
            <p><strong>Quotation Date:</strong> {{ $purchaseOrder->quotation_date ?? 'N/A' }}</p>
        </div>
    </div>

    @if($purchaseOrder->items && count($purchaseOrder->items) > 0)
    <table>
        <thead>
            <tr>
                <th>Sr. No</th>
                <th>Item</th>
                <th>Description</th>
                <th>Quantity</th>
                <th>Rate</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            @foreach($purchaseOrder->items as $index => $item)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $item->stockItem->name ?? 'N/A' }}</td>
                <td>{{ $item->description }}</td>
                <td>{{ $item->quantity }}</td>
                <td>₹{{ number_format($item->rate, 2) }}</td>
                <td>₹{{ number_format($item->amount, 2) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endif

    <div class="total-section">
        <table style="width: 300px; margin-left: auto;">
            <tr>
                <td><strong>Subtotal:</strong></td>
                <td>₹{{ number_format($purchaseOrder->subtotal, 2) }}</td>
            </tr>
            <tr>
                <td><strong>SGST:</strong></td>
                <td>₹{{ number_format($purchaseOrder->sgst_amount, 2) }}</td>
            </tr>
            <tr>
                <td><strong>CGST:</strong></td>
                <td>₹{{ number_format($purchaseOrder->cgst_amount, 2) }}</td>
            </tr>
            <tr>
                <td><strong>IGST:</strong></td>
                <td>₹{{ number_format($purchaseOrder->igst_amount, 2) }}</td>
            </tr>
            <tr>
                <td><strong>Additional Charges:</strong></td>
                <td>₹{{ number_format($purchaseOrder->additional_charges, 2) }}</td>
            </tr>
            <tr>
                <td><strong>TDS:</strong></td>
                <td>₹{{ number_format($purchaseOrder->tds_amount, 2) }}</td>
            </tr>
            <tr style="border-top: 2px solid #333;">
                <td><strong>Total:</strong></td>
                <td><strong>₹{{ number_format($purchaseOrder->subtotal + $purchaseOrder->sgst_amount + $purchaseOrder->cgst_amount + $purchaseOrder->igst_amount + $purchaseOrder->additional_charges - $purchaseOrder->tds_amount, 2) }}</strong></td>
            </tr>
        </table>
    </div>

    <div class="footer">
        <p>This is a computer generated document. No signature required.</p>
        <p>Generated on: {{ date('Y-m-d H:i:s') }}</p>
    </div>
</body>
</html> 