@extends('layouts.dashboard.superadminapp')

@section('title', 'RFQ List')

@section('content')
    <style>
        div.dt-buttons {
            float: left;
            display: flex !important;
            margin-bottom: 1rem;
        }

        .dataTable {
            overflow-x: auto !important;
            display: table !important;
        }

        .dt-buttons .btn {
            margin-right: 0.5rem !important;
            padding: 0.25rem 0.75rem !important;
            font-size: 0.95rem !important;
        }

        .btn-delete {
            min-width: 80px;
        }

        .page-header-icon {
            font-size: 2rem;
            color: #506690;
            vertical-align: middle;
        }
    </style>

    <!-- Page Heading -->
    <div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h5 mb-0 text-gray-800 pl-2">UEPL | RFQ List</h1>
        <div class="display-date">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time"></div>
    </div>

    <!-- Alerts -->
    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif


    <!-- Table Section -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
            <h6 class="m-0 font-weight-bold text-white">
                <i class="fas fa-list mr-2"></i> RFQ List
            </h6>
            <a href="{{ route('superadmin.purchasebom.rfq.rfq') }}" class="btn btn-light btn-sm" title="Add New">
                <i class="fa fa-plus mr-1"></i> Add RFQ
            </a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-sm" id="rfqTable" width="100%" cellspacing="0">
                    <thead class="thead-light">
                        <tr>
                            <th>RFQ ID</th>
                            <th>RFQ Date</th>
                            <th>Vendor</th>
                            <th>Vendor Ref No</th>
                            <th>RFQ Type</th>
                            <th class="text-center">Status</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($rfqs as $rfq)
                            <tr id="row-{{ $rfq->id }}">
                                <td>{{ $rfq->rfq_no }}</td>
                                <td>{{ $rfq->rfq_date }}</td>
                                <td>{{ $rfq->customerInfo ? $rfq->customerInfo->company : '-' }}</td>
                                <td>{{ $rfq->vendor_reference_no }}</td>
                                <td>{{ $rfq->rfq_type }}</td>
                                <td class="text-center">
                                    <span class="badge {{ $rfq->status == 'approved' ? 'bg-success' : ($rfq->status == 'rejected' ? 'bg-danger' : 'bg-secondary') }}" style="color:white">
                                        {{ ucfirst($rfq->status) }}
                                    </span>
                                </td>
                                <td class="text-center" style="white-space: nowrap;">
                                    <a href="{{ route('superadmin.purchasebom.rfq.print', $rfq->id) }}"
                                        class="btn btn-success btn-sm" target="_blank" title="Print">
                                        <i class="fa fa-print"></i>
                                    </a>
                                    <a href="{{ route('superadmin.purchasebom.rfq.view', $rfq->id) }}"
                                        class="btn btn-info btn-sm" title="View">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                    <a href="{{ route('superadmin.purchasebom.rfq.edit', $rfq->id) }}"
                                        class="btn btn-warning btn-sm" title="Edit">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                    @if ($rfq->status === 'pending')
                                        <button class="btn btn-outline-success btn-sm approve-btn"
                                            data-id="{{ $rfq->id }}" title="Approve">
                                            <i class="fa fa-check"></i>
                                        </button>
                                        <button class="btn btn-outline-danger btn-sm reject-btn"
                                            data-id="{{ $rfq->id }}" title="Reject">
                                            <i class="fa fa-times"></i>
                                        </button>
                                    @endif
                                    <button class="btn btn-danger btn-sm delete-btn"
                                        data-id="{{ $rfq->id }}" title="Delete">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Approve
        $(document).on('click', '.approve-btn', function() {
            var id = $(this).data('id');
            Swal.fire({
                title: 'Approve RFQ?',
                text: "Are you sure you want to approve this RFQ?",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#28a745',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, Approve',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.post("{{ url('superadmin/purchase/rfq') }}/" + id + "/approve", {
                        _token: "{{ csrf_token() }}"
                    }, function(response) {
                        Swal.fire('Approved!', response.message, 'success').then(() => location.reload());
                    }).fail(function() {
                        Swal.fire('Error', 'Approval failed.', 'error');
                    });
                }
            });
        });

        // Reject
        $(document).on('click', '.reject-btn', function() {
            var id = $(this).data('id');
            Swal.fire({
                title: 'Reject RFQ?',
                text: "Are you sure you want to reject this RFQ?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, Reject',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.post("{{ url('superadmin/purchase/rfq') }}/" + id + "/reject", {
                        _token: "{{ csrf_token() }}"
                    }, function(response) {
                        Swal.fire('Rejected!', response.message, 'success').then(() => location.reload());
                    }).fail(function() {
                        Swal.fire('Error', 'Rejection failed.', 'error');
                    });
                }
            });
        });

        $(document).ready(function() {
            $('#rfqTable').DataTable({
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'copy',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'csv',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'excel',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'pdf',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'print',
                        className: 'btn btn-secondary btn-sm'
                    },
                    {
                        extend: 'colvis',
                        className: 'btn btn-secondary btn-sm'
                    }
                ],
                pageLength: 10,
                ordering: true,
                searching: true,
                responsive: true,
            });

            // Delete RFQ with SweetAlert2 confirm
            $(document).on('click', '.delete-btn', function() {
                var id = $(this).data('id');
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You want to delete this RFQ!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, Delete!',
                    reverseButtons: true
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "{{ url('superadmin/purchase/rfq') }}/" + id,
                            type: 'DELETE',
                            data: {
                                _token: "{{ csrf_token() }}"
                            },
                            success: function(response) {
                                $('#row-' + id).fadeOut(500, function() {
                                    $(this).remove();
                                });
                                Swal.fire('Deleted!', 'RFQ deleted successfully.',
                                    'success');
                                location.reload(); // reload page after alert closes
                            },
                            error: function(xhr) {
                                Swal.fire('Error', 'Error occurred while deleting.',
                                    'error');
                                location.reload(); // reload page after alert closes
                            }
                        });
                    }
                });
            });
        });
    </script>
@endsection