<div class="modal fade" id="machineModel" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Operator Assignments</h5>
                <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">
                    <span>x</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="assignOperatorForm" class="form-horizontal">
                    @csrf
                    <div class="row">
                        <!-- Machine Select -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="machineSelect">Select Machine</label>
                                <select class="form-control" id="machineSelect" name="machine_id">
                                    <option value="">Select Machine</option>
                                    @foreach ($machines as $machine)
                                        <option value="{{ $machine->id }}">{{ $machine->machine_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <!-- Operator Select -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="operatorSelect">Select Operator</label>
                                <select class="form-control selectpicker" id="operatorSelect" multiple data-live-search="true"
                                    name="operators[]">
                                    @foreach ($employees as $employee)
                                        <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="form-group mt-3 text-end">
                        <button type="submit" class="btn btn-primary" id="assignOperatorBtn">Assign Operator</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
@section('assign_operators_scripts')
    <script>
        function handleMachineSelection() {
            let selectedMachine = $('#machineSelect').val();
            if (selectedMachine) {
                $('#machineTable tbody tr').each(function() {
                    let machineId = $(this).data('machine-id');
                    if (machineId == selectedMachine || selectedMachine === '') {
                        $(this).removeClass('d-none');
                    } else {
                        $(this).addClass('d-none');
                    }
                });
            }
        }
        document.addEventListener('DOMContentLoaded', function() {
            handleMachineSelection();
            $('#machineSelect').change(function() {
                handleMachineSelection();
            });
            let form = document.getElementById('assignOperatorForm');
            const machineModel = new bootstrap.Modal(document.getElementById('machineModel'));
            form.addEventListener('submit', function(event) {
                event.preventDefault();
                const formData = new FormData(form);
                let machineId = $('#machineSelect').val();
                let operatorIds = $('#operatorSelect').val();
                if (!machineId || !operatorIds) {
                    alert('Please select a machine and at least one operator.');
                    return;
                }
                let url = "{{ route('superadmin.machine.assignOperators') }}";
                fetch(url, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': "{{ csrf_token() }}"
                        },
                        body: formData
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.success) {
                            form.reset();
                            machineModel.hide();
                            location.reload();
                        } else {
                            alert('Error: ' + data.message);
                        }
                    });
            });
        });
    </script>
@endsection
