@extends('layouts.dashboard.superadminapp')

@section('title', 'View Invoice')

@section('styles')
<style>
    .invoice-container {
        background: #fff;
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(0,0,0,0.1);
        padding: 30px;
    }
    .invoice-header {
        border-bottom: 3px solid #4e73df;
        padding-bottom: 20px;
        margin-bottom: 20px;
    }
    .invoice-header .company-logo img {
        height: 60px;
    }
    .invoice-header h2 {
        color: #4e73df;
        margin: 0;
    }
    .invoice-meta td {
        padding: 8px 15px;
        border: 1px solid #dee2e6;
    }
    .invoice-meta strong {
        color: #4e73df;
    }
    .section-title {
        background: #4e73df;
        color: #fff;
        padding: 10px 15px;
        border-radius: 5px;
        margin: 20px 0 15px 0;
        font-weight: 600;
    }
    .items-table th {
        background: #4e73df;
        color: #fff;
    }
    .items-table td, .items-table th {
        padding: 10px;
        vertical-align: middle;
    }
    .summary-table td {
        padding: 8px 15px;
    }
    .status-badge {
        font-size: 1rem;
        padding: 8px 20px;
    }
    .approval-info {
        background: #f8f9fc;
        border-radius: 8px;
        padding: 15px;
        margin-top: 20px;
    }
</style>
@endsection

@section('content')
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">View Invoice: {{ $invoice->invoice_no }}</h1>
    <div>
        <a href="{{ route('superadmin.invoice.invoicedetails') }}" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left mr-1"></i> Back to List
        </a>
        <a href="{{ route('superadmin.invoice.print', $invoice->id) }}" target="_blank" class="btn btn-info btn-sm">
            <i class="fas fa-print mr-1"></i> Print
        </a>
        <a href="{{ route('superadmin.invoice.edit', $invoice->id) }}" class="btn btn-warning btn-sm">
            <i class="fas fa-edit mr-1"></i> Edit
        </a>
    </div>
</div>

<div class="invoice-container">
    <!-- Status Badge -->
    <div class="text-right mb-3">
        @php
            $status = $invoice->status ?? 'pending';
            $statusClass = match($status) {
                'approved' => 'success',
                'rejected' => 'danger',
                default => 'warning'
            };
        @endphp
        <span class="badge badge-{{ $statusClass }} status-badge">
            <i class="fas fa-{{ $status === 'approved' ? 'check-circle' : ($status === 'rejected' ? 'times-circle' : 'clock') }} mr-1"></i>
            {{ ucfirst($status) }}
        </span>
    </div>

    <!-- Invoice Header -->
    <div class="invoice-header d-flex align-items-center">
        <div class="company-logo mr-4">
            <img src="{{ asset('cbimage.png') }}" alt="Company Logo">
        </div>
        <div>
            <h2>UMBREY ENGINEERING PVT LTD</h2>
            <p class="mb-0 text-muted">
                No. 31, 2nd Phase, Peenya Industrial Area, Bengaluru 560 058, Karnataka, India<br>
                GSTN: 29AAACU2461N1ZY | PAN: AAACU2461N
            </p>
        </div>
    </div>

    <!-- Invoice Meta Info -->
    <div class="row">
        <div class="col-md-6">
            <table class="table table-bordered invoice-meta">
                <tr>
                    <td><strong>Invoice No:</strong></td>
                    <td>{{ $invoice->invoice_no }}</td>
                </tr>
                <tr>
                    <td><strong>Invoice Date:</strong></td>
                    <td>{{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d-m-Y') }}</td>
                </tr>
                <tr>
                    <td><strong>Reference No:</strong></td>
                    <td>{{ $invoice->reference_no ?? '-' }}</td>
                </tr>
                <tr>
                    <td><strong>Buyer Order No:</strong></td>
                    <td>{{ $invoice->buyer_order_no ?? '-' }}</td>
                </tr>
            </table>
        </div>
        <div class="col-md-6">
            <table class="table table-bordered invoice-meta">
                <tr>
                    <td><strong>Delivery Note:</strong></td>
                    <td>{{ $invoice->delivery_note ?? '-' }}</td>
                </tr>
                <tr>
                    <td><strong>Terms of Payment:</strong></td>
                    <td>{{ $invoice->terms_payment ?? '-' }}</td>
                </tr>
                <tr>
                    <td><strong>Dispatch Through:</strong></td>
                    <td>{{ $invoice->dispatch_through ?? '-' }}</td>
                </tr>
                <tr>
                    <td><strong>Destination:</strong></td>
                    <td>{{ $invoice->destination ?? '-' }}</td>
                </tr>
            </table>
        </div>
    </div>

    <!-- Buyer Info -->
    <div class="section-title">
        <i class="fas fa-building mr-2"></i>Buyer Information
    </div>
    <div class="row">
        <div class="col-md-6">
            <table class="table table-bordered">
                <tr>
                    <td><strong>Company:</strong></td>
                    <td>{{ $invoice->company->company ?? '-' }}</td>
                </tr>
                <tr>
                    <td><strong>Address:</strong></td>
                    <td>{{ $invoice->address ?? '-' }}</td>
                </tr>
                <tr>
                    <td><strong>GST No:</strong></td>
                    <td>{{ $invoice->gst ?? '-' }}</td>
                </tr>
            </table>
        </div>
        <div class="col-md-6">
            <table class="table table-bordered">
                <tr>
                    <td><strong>Email:</strong></td>
                    <td>{{ $invoice->email ?? '-' }}</td>
                </tr>
                <tr>
                    <td><strong>Phone:</strong></td>
                    <td>{{ $invoice->phone ?? '-' }}</td>
                </tr>
                <tr>
                    <td><strong>Vehicle No:</strong></td>
                    <td>{{ $invoice->vehicle_no ?? '-' }}</td>
                </tr>
            </table>
        </div>
    </div>

    <!-- Invoice Items -->
    <div class="section-title">
        <i class="fas fa-list mr-2"></i>Invoice Items
    </div>
    <div class="table-responsive">
        <table class="table table-bordered items-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Description</th>
                    <th>HSN/SAC</th>
                    <th class="text-right">Qty</th>
                    <th class="text-right">Rate</th>
                    <th>Per</th>
                    <th class="text-right">SGST (%)</th>
                    <th class="text-right">CGST (%)</th>
                    <th class="text-right">IGST (%)</th>
                    <th class="text-right">Amount</th>
                </tr>
            </thead>
            <tbody>
                @forelse($invoice->items as $i => $item)
                <tr>
                    <td>{{ $i + 1 }}</td>
                    <td>{{ $item->description }}</td>
                    <td>{{ $item->hsn }}</td>
                    <td class="text-right">{{ $item->quantity }}</td>
                    <td class="text-right">{{ number_format($item->rate, 2) }}</td>
                    <td>{{ $item->per }}</td>
                    <td class="text-right">{{ $item->sgst }}</td>
                    <td class="text-right">{{ $item->cgst }}</td>
                    <td class="text-right">{{ $item->igst }}</td>
                    <td class="text-right">{{ number_format($item->amount, 2) }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="10" class="text-center">No items found</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Summary -->
    <div class="row justify-content-end">
        <div class="col-md-5">
            <table class="table table-bordered summary-table">
                <tr>
                    <td class="text-right"><strong>Taxable Value:</strong></td>
                    <td class="text-right" style="width: 150px;">₹{{ number_format($invoice->taxable_value, 2) }}</td>
                </tr>
                <tr>
                    <td class="text-right"><strong>SGST:</strong></td>
                    <td class="text-right">₹{{ number_format($invoice->sgst, 2) }}</td>
                </tr>
                <tr>
                    <td class="text-right"><strong>CGST:</strong></td>
                    <td class="text-right">₹{{ number_format($invoice->cgst, 2) }}</td>
                </tr>
                <tr>
                    <td class="text-right"><strong>IGST:</strong></td>
                    <td class="text-right">₹{{ number_format($invoice->igst, 2) }}</td>
                </tr>
                <tr>
                    <td class="text-right"><strong>Total Tax:</strong></td>
                    <td class="text-right">₹{{ number_format($invoice->total_tax_amount, 2) }}</td>
                </tr>
                <tr class="table-primary">
                    <td class="text-right"><strong>Total Amount:</strong></td>
                    <td class="text-right"><strong>₹{{ number_format($invoice->total_amount, 2) }}</strong></td>
                </tr>
                <tr>
                    <td class="text-right"><strong>Amount in Words:</strong></td>
                    <td class="text-right"><em>{{ $invoice->amount_in_words }}</em></td>
                </tr>
            </table>
        </div>
    </div>

    <!-- Approval Info -->
    @if($invoice->status !== 'pending')
    <div class="approval-info">
        <h6 class="font-weight-bold text-primary mb-3">
            <i class="fas fa-info-circle mr-1"></i>Approval Information
        </h6>
        <div class="row">
            <div class="col-md-4">
                <strong>Status:</strong><br>
                <span class="badge badge-{{ $statusClass }}">{{ ucfirst($invoice->status) }}</span>
            </div>
            <div class="col-md-4">
                <strong>{{ $invoice->status === 'approved' ? 'Approved' : 'Rejected' }} At:</strong><br>
                {{ $invoice->approved_at ? $invoice->approved_at->format('d-m-Y H:i') : '-' }}
            </div>
            <div class="col-md-4">
                <strong>Remarks:</strong><br>
                {{ $invoice->approval_remarks ?? '-' }}
            </div>
        </div>
    </div>
    @endif
</div>
@endsection
