@extends('layouts.dashboard.superadminapp')
@section('title', 'SuperAdmin GRN Order')

@section('styles')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
    #productTable input.form-control { padding: 0.25rem 0.5rem; font-size: 0.875rem; }
    .select2-container .select2-selection--single { height: 38px; }
    .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 38px; }
    .select2-container--default .select2-selection--single .select2-selection__arrow { height: 38px; }
</style>
@endsection

@section('content')

<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL | Goods Received Note</h1>
    <div class="display-date">
        <span id="day">{{ now()->format('l') }}</span>,
        <span id="daynum">{{ now()->format('d') }}</span>
        <span id="month">{{ now()->format('F') }}</span>
        <span id="year">{{ now()->format('Y') }}</span>
    </div>
    <div class="display-time">{{ now()->format('h:i:s A') }}</div>
</div>

<!-- Alerts -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle mr-2"></i>{{ session('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>{{ session('error') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif
@if ($errors->any())
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle mr-2"></i>
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
@endif

<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center" style="background: linear-gradient(135deg, #4e73df 0%, #224abe 100%);">
        <h6 class="m-0 font-weight-bold text-white">
            <i class="fas fa-clipboard-check mr-2"></i> Create Goods Received Note
        </h6>
        <a href="{{ route('superadmin.grn.grndetails') }}" class="btn btn-light btn-sm">
            <i class="fa fa-arrow-left mr-1"></i> Back to List
        </a>
    </div>
    <div class="card-body">
        <form method="POST" action="{{ route('superadmin.grn.store') }}" enctype="multipart/form-data" id="grnForm">
            @csrf

            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">GRN ID <span class="text-danger">*</span></label>
                    <input type="text" id="grnNo" name="grn_no" class="form-control" value="{{ $grnNo }}" readonly>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">GRN Date <span class="text-danger">*</span></label>
                    <input type="date" id="grnDate" name="grn_date" class="form-control" required>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Order Type</label>
                    <select id="orderTypeSelect" class="form-control">
                        <option value="">Select Type (Optional)</option>
                        <option value="purchase">Purchase Order</option>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Order ID</label>
                    <select id="orderNoSelect" name="order_no" class="form-control">
                        <option value="">Select Order (Optional)</option>
                    </select>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Order Date</label>
                    <input type="date" id="orderDate" name="order_date" class="form-control" readonly>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Order Reference No</label>
                    <input type="text" id="orderRefNo" name="order_ref_no" class="form-control">
                </div>
            </div>

            <!-- Purchase Invoice Selection -->
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">
                        <i class="fas fa-file-invoice text-primary mr-1"></i>
                        Purchase Invoice (Optional)
                    </label>
                    <select id="purchaseInvoiceSelect" name="purchase_invoice_id" class="form-control">
                        <option value="">Select Purchase Invoice</option>
                    </select>
                    <small class="text-muted">Select a purchase invoice to auto-fill details</small>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Invoice Details</label>
                    <div id="purchaseInvoiceDetails" class="small text-muted p-2 bg-light rounded" style="min-height: 38px;">
                        Select a purchase invoice to view details
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Order Company Name <span class="text-danger">*</span></label>
                    <select id="companyNameSelect" name="company_name" class="form-control" required onchange="fillCompanyDetails(this)">
                        <option value="">Select Company</option>
                        @foreach ($companies as $company)
                            <option value="{{ $company->company }}"
                                data-address="{{ $company->billing_Address }}"
                                data-gst="{{ $company->gstno }}"
                                data-email="{{ $company->email }}"
                                data-phone="{{ $company->mobile }}">
                                {{ $company->company }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="small font-weight-bold">Address</label>
                    <input type="text" id="companyAddress" name="company_address" class="form-control">
                </div>
            </div>

            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">GST No</label>
                    <input type="text" id="companyGSTN" name="company_gstn" class="form-control">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Email</label>
                    <input type="email" id="companyEmail" name="company_email" class="form-control">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Contact Number</label>
                    <input type="tel" id="companyPhone" name="company_phone" class="form-control">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Quotation ID</label>
                    <input type="text" id="quotationNo" name="quotation_no" class="form-control">
                </div>
            </div>

            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Quotation Date</label>
                    <input type="date" id="quotationDate" name="quotation_date" class="form-control">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">RFQ No</label>
                    <input type="text" id="rfqNo" name="rfq_no" class="form-control">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">RFQ Date</label>
                    <input type="date" id="rfqDate" name="rfq_date" class="form-control">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Part No</label>
                    <input type="text" id="partNo" name="part_no" class="form-control">
                </div>
            </div>

            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Project Material No</label>
                    <input type="text" id="project-materialNo" name="project_material_no" class="form-control">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Drawing No</label>
                    <input type="text" id="drawingNo" name="drawing_no" class="form-control">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Drawing Revision</label>
                    <input type="text" id="drawingRev" name="drawing_rev" class="form-control">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="small font-weight-bold">Upload Challan (PDF)</label>
                    <input type="file" id="grnChallan" name="challan" accept=".pdf" class="form-control">
                </div>
            </div>

            <div class="row">
                <div class="col-md-12 mb-3">
                    <label class="small font-weight-bold">Description</label>
                    <textarea id="description" name="description" rows="2" class="form-control"></textarea>
                </div>
            </div>

            <hr>

            <h6 class="font-weight-bold text-primary mb-3"><i class="fas fa-boxes mr-2"></i>Product Details</h6>

            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="small font-weight-bold">Product Type</label>
                    <input type="text" id="productType" name="product_type" class="form-control">
                </div>
            </div>

            <div class="table-responsive">
                <table id="productTable" class="table table-bordered table-sm">
                    <thead class="thead-light">
                        <tr>
                            <th width="50">Sl No.</th>
                            <th>Description</th>
                            <th width="100">Quantity</th>
                            <th width="80">UOM</th>
                            <th width="130">Date</th>
                            <th>Supplier</th>
                            <th>Remarks</th>
                            <th width="50"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>1</td>
                            <td>
                                <select name="products[0][description]" class="description form-control stock-item-select" style="width: 100%;" required>
                                    <option value="">Search or type...</option>
                                </select>
                            </td>
                            <td><input type="number" name="products[0][quantity]" class="quantity form-control" required></td>
                            <td><input type="text" name="products[0][unit]" class="unit form-control" required></td>
                            <td><input type="date" name="products[0][date]" class="date form-control" required></td>
                            <td><input type="text" name="products[0][supplier]" class="supplier form-control"></td>
                            <td><input type="text" name="products[0][remarks]" class="remarks form-control"></td>
                            <td><button class="btn btn-danger btn-sm" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="mb-3">
                <button type="button" class="btn btn-primary btn-sm" onclick="addRow()">
                    <i class="fa fa-plus mr-1"></i> Add Row
                </button>
            </div>

            <hr>

            <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-success btn-sm mr-2" id="save-GRN">
                    <i class="fa fa-save mr-1"></i> Save
                </button>
                <button type="reset" class="btn btn-secondary btn-sm mr-2">
                    <i class="fa fa-times mr-1"></i> Clear
                </button>
                <a href="{{ route('superadmin.grn.grndetails') }}" class="btn btn-outline-secondary btn-sm">
                    <i class="fa fa-arrow-left mr-1"></i> Back
                </a>
            </div>
        </form>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Set GRN date to today
    document.getElementById('grnDate').value = new Date().toISOString().split('T')[0];

    let ordersData = [];

    // When order type changes, load orders
    document.getElementById('orderTypeSelect').addEventListener('change', function () {
        const type = this.value;
        loadOrderDropdown(type);
    });

    // When order is selected, autofill details
    document.getElementById('orderNoSelect').addEventListener('change', function () {
        const orderNo = this.value;
        const type = document.getElementById('orderTypeSelect').value;
        if (!orderNo || !type) return;
        fetch("{{ url('superadmin/grn/order-details') }}?type=" + type + "&order_no=" + orderNo)
            .then(r => r.json())
            .then(order => {
                if (order.error) return;
                document.getElementById('orderDate').value = (type === 'sales' ? order.sales_order_date : order.purchase_order_date) || '';
                // Auto-fill company/vendor/customer details
                if (type === 'sales' && order.customer) {
                    document.getElementById('companyNameSelect').value = order.customer.company || '';
                    document.getElementById('companyAddress').value = order.company_address || '';
                    document.getElementById('companyGSTN').value = order.customer.gstno || '';
                    document.getElementById('companyEmail').value = order.customer.email || '';
                    document.getElementById('companyPhone').value = order.customer.mobile || '';
                } else if (type === 'purchase' && order.vendor) {
                    document.getElementById('companyNameSelect').value = order.vendor.company || '';
                    document.getElementById('companyAddress').value = order.company_address || '';
                    document.getElementById('companyGSTN').value = order.company_gstn || '';
                    document.getElementById('companyEmail').value = order.company_email || '';
                    document.getElementById('companyPhone').value = order.company_phone || '';
                }
                document.getElementById('orderRefNo').value = order.customer_ref_no || '';
                document.getElementById('quotationNo').value = order.quotation_no || '';
                document.getElementById('quotationDate').value = order.quotation_date || '';
                document.getElementById('rfqNo').value = order.rfq_no || '';
                document.getElementById('rfqDate').value = order.rfq_date || '';
                document.getElementById('partNo').value = order.part_no || '';
                document.getElementById('project-materialNo').value = order.project_material_no || '';
                document.getElementById('drawingNo').value = order.drawing_no || '';
                document.getElementById('drawingRev').value = order.drawing_rev || '';
                document.getElementById('description').value = order.description || '';
                document.getElementById('productType').value = order.product_type || '';
            });
    });

    function loadOrderDropdown(type) {
        if (!type) {
            document.getElementById('orderNoSelect').innerHTML = '<option value="">Select Order</option>';
            return;
        }
        fetch("{{ url('superadmin/grn/available-orders') }}")
            .then(r => r.json())
            .then(data => {
                ordersData = data;
                const options = data
                    .filter(o => o.order_type === type)
                    .map(o => `<option value="${o.order_no}">${o.order_no}</option>`);
                document.getElementById('orderNoSelect').innerHTML =
                    '<option value="">Select Order</option>' + options.join('');
            });
    }

    // Load available Purchase Invoices
    loadPurchaseInvoices();

    function loadPurchaseInvoices() {
        fetch("{{ url('superadmin/grn/available-purchase-invoices') }}")
            .then(r => r.json())
            .then(data => {
                const options = data.map(inv =>
                    `<option value="${inv.id}" data-vendor="${inv.vendor_name}" data-total="${inv.grand_total}">
                        ${inv.purchase_no} - ${inv.vendor_name} (${inv.vendor_invoice_no || 'N/A'})
                    </option>`
                );
                document.getElementById('purchaseInvoiceSelect').innerHTML =
                    '<option value="">Select Purchase Invoice</option>' + options.join('');
            });
    }

    // Handle Purchase Invoice selection
    document.getElementById('purchaseInvoiceSelect').addEventListener('change', function() {
        const invoiceId = this.value;
        if (!invoiceId) {
            document.getElementById('purchaseInvoiceDetails').innerHTML = 'Select a purchase invoice to view details';
            return;
        }

        fetch("{{ url('superadmin/grn/purchase-invoice-details') }}/" + invoiceId)
            .then(r => r.json())
            .then(data => {
                if (!data.success) {
                    document.getElementById('purchaseInvoiceDetails').innerHTML = 'Error loading invoice details';
                    return;
                }

                const inv = data.invoice;
                // Display invoice summary
                document.getElementById('purchaseInvoiceDetails').innerHTML =
                    `<strong>${inv.purchase_no}</strong><br>` +
                    `Vendor: ${inv.party ? inv.party.company : 'N/A'}<br>` +
                    `Date: ${inv.purchase_date}<br>` +
                    `Total: ₹${parseFloat(inv.grand_total || 0).toLocaleString('en-IN', {minimumFractionDigits: 2})}`;

                // Auto-fill company details from purchase invoice
                if (inv.party) {
                    // Try to select the company in the dropdown
                    const companySelect = document.getElementById('companyNameSelect');
                    for (let i = 0; i < companySelect.options.length; i++) {
                        if (companySelect.options[i].value === inv.party.company) {
                            companySelect.selectedIndex = i;
                            fillCompanyDetails(companySelect);
                            break;
                        }
                    }
                }

                // Auto-fill product details if available
                if (data.items && data.items.length > 0) {
                    const tableBody = document.querySelector("#productTable tbody");
                    // Clear existing rows
                    tableBody.innerHTML = '';

                    data.items.forEach((item, index) => {
                        const row = document.createElement("tr");
                        row.innerHTML = `
                            <td>${index + 1}</td>
                            <td><input type="text" name="products[${index}][description]" class="description form-control" value="${item.description || ''}"></td>
                            <td><input type="number" name="products[${index}][quantity]" class="quantity form-control" value="${item.quantity || ''}"></td>
                            <td><input type="text" name="products[${index}][unit]" class="unit form-control" value="${item.unit || 'Nos'}"></td>
                            <td><input type="date" name="products[${index}][date]" class="date form-control" value="${new Date().toISOString().split('T')[0]}"></td>
                            <td><input type="text" name="products[${index}][supplier]" class="supplier form-control"></td>
                            <td><input type="text" name="products[${index}][remarks]" class="remarks form-control"></td>
                            <td><button class="btn btn-danger" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
                        `;
                        tableBody.appendChild(row);
                    });
                }
            })
            .catch(err => {
                console.error('Error loading invoice details:', err);
                document.getElementById('purchaseInvoiceDetails').innerHTML = 'Error loading invoice details';
            });
    });
});

function addRow() {
    const table = document.querySelector("#productTable tbody");
    const index = table.rows.length;
    const row = document.createElement("tr");
    row.innerHTML = `
        <td>${index + 1}</td>
        <td>
            <select name="products[${index}][description]" class="description form-control stock-item-select" style="width: 100%;" required>
                <option value="">Search or type...</option>
            </select>
        </td>
        <td><input type="number" name="products[${index}][quantity]" class="quantity form-control" required></td>
        <td><input type="text" name="products[${index}][unit]" class="unit form-control" required></td>
        <td><input type="date" name="products[${index}][date]" class="date form-control" required></td>
        <td><input type="text" name="products[${index}][supplier]" class="supplier form-control"></td>
        <td><input type="text" name="products[${index}][remarks]" class="remarks form-control"></td>
        <td><button class="btn btn-danger btn-sm" type="button" onclick="deleteRow(this)"><i class="fa fa-trash"></i></button></td>
    `;
    table.appendChild(row);
    // Initialize Select2 on the new row
    initStockItemSelect(row.querySelector('.stock-item-select'));
}

function deleteRow(button) {
    const row = button.closest("tr");
    row.remove();
    // Re-index remaining rows
    const rows = document.querySelectorAll("#productTable tbody tr");
    rows.forEach((tr, i) => {
        tr.querySelectorAll("input").forEach(input => {
            const name = input.name.replace(/products\[\d+\]/, `products[${i}]`);
            input.name = name;
        });
        tr.querySelector("td").textContent = i + 1;
    });
}

function fillCompanyDetails(select) {
    const selected = select.options[select.selectedIndex];
    document.getElementById('companyAddress').value = selected.getAttribute('data-address') || '';
    document.getElementById('companyGSTN').value = selected.getAttribute('data-gst') || '';
    document.getElementById('companyEmail').value = selected.getAttribute('data-email') || '';
    document.getElementById('companyPhone').value = selected.getAttribute('data-phone') || '';
}

// Initialize Select2 for Stock Item dropdown with search capability
function initStockItemSelect(element) {
    $(element).select2({
        placeholder: 'Search stock item...',
        allowClear: true,
        tags: true, // Allow custom values
        createTag: function (params) {
            return {
                id: params.term,
                text: params.term,
                newTag: true
            };
        },
        ajax: {
            url: "{{ url('superadmin/grn/search-stock-items') }}",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return { q: params.term };
            },
            processResults: function (data) {
                return { results: data.results };
            },
            cache: true
        },
        minimumInputLength: 0,
        width: '100%'
    }).on('select2:select', function (e) {
        // Auto-fill UOM when stock item is selected
        var data = e.params.data;
        if (data.uom) {
            var row = $(this).closest('tr');
            row.find('.unit').val(data.uom);
        }
    });
}

// Initialize all existing stock item selects on page load
$(document).ready(function() {
    $('.stock-item-select').each(function() {
        initStockItemSelect(this);
    });
});
</script>
@endsection
