<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Payslip</title>
    <style>
        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            font-size: 12px;
            color: #333;
        }
        .container {
            width: 100%;
            margin: 0 auto;
            border: 1px solid #ccc;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #4e73df;
            padding-bottom: 10px;
        }
        .header h1 {
            color: #4e73df;
            margin: 0;
            font-size: 24px;
            text-transform: uppercase;
        }
        .header p {
            margin: 5px 0;
            font-size: 10px;
            color: #666;
        }
        .payslip-title {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 20px;
            text-decoration: underline;
        }
        .emp-details {
            width: 100%;
            margin-bottom: 20px;
        }
        .emp-details td {
            padding: 5px;
        }
        .label {
            font-weight: bold;
            color: #555;
            width: 120px;
        }
        .table-salary {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .table-salary th, .table-salary td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .table-salary th {
            background-color: #f8f9fc;
            color: #4e73df;
            text-align: center;
        }
        .amount {
            text-align: right;
        }
        .net-pay {
            background-color: #4e73df;
            color: white;
            font-size: 14px;
            font-weight: bold;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            width: 100%;
        }
        .signature {
            border-top: 1px solid #333;
            width: 200px;
            display: inline-block;
            margin: 0 50px;
            padding-top: 5px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>UEPL</h1>
            <h3>Universal Engineering Pvt Ltd</h3>
            <p>123, Industrial Area, Solapur, Maharashtra - 413001</p>
        </div>

        <div class="payslip-title">PAYSLIP FOR THE MONTH OF {{ strtoupper(\Carbon\Carbon::parse($salary->month_year)->format('F Y')) }}</div>

        <table class="emp-details">
            <tr>
                <td class="label">Employee Name:</td>
                <td>{{ $salary->employee->name ?? 'N/A' }}</td>
                <td class="label">Employee ID:</td>
                <td>{{ $salary->employee->employee_id ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td class="label">Department:</td>
                <td>{{ $salary->employee->department ?? '-' }}</td>
                <td class="label">Designation:</td>
                <td>{{ $salary->employee->designation ?? '-' }}</td>
            </tr>
            <tr>
                <td class="label">Days Worked:</td>
                <td>{{ $salary->no_of_days_worked }}</td>
                <td class="label">Paid Leaves:</td>
                <td>{{ $salary->leave_given }}</td>
            </tr>
            <tr>
                <td class="label">Payment Mode:</td>
                <td>{{ $salary->payment_mode ?? '-' }}</td>
                <td class="label">Generated On:</td>
                <td>{{ date('d-m-Y') }}</td>
            </tr>
        </table>

        <table class="table-salary">
            <thead>
                <tr>
                    <th colspan="2">EARNINGS</th>
                    <th colspan="2">DEDUCTIONS</th>
                </tr>
                <tr>
                    <th>Description</th>
                    <th>Amount (₹)</th>
                    <th>Description</th>
                    <th>Amount (₹)</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Basic & DA</td>
                    <td class="amount">{{ number_format($salary->basic_da, 2) }}</td>
                    <td>PF</td>
                    <td class="amount">{{ number_format($salary->pf, 2) }}</td>
                </tr>
                <tr>
                    <td>HRA</td>
                    <td class="amount">{{ number_format($salary->hra, 2) }}</td>
                    <td>ESI</td>
                    <td class="amount">{{ number_format($salary->esi, 2) }}</td>
                </tr>
                <tr>
                    <td>Conveyance</td>
                    <td class="amount">{{ number_format($salary->conveyance, 2) }}</td>
                    <td>Professional Tax</td>
                    <td class="amount">{{ number_format($salary->pt, 2) }}</td>
                </tr>
                <tr>
                    <td>Washing Allowance</td>
                    <td class="amount">{{ number_format($salary->washing_allowance, 2) }}</td>
                    <td>Advance Deduction</td>
                    <td class="amount">{{ number_format($salary->advance_deduction, 2) }}</td>
                </tr>
                <tr>
                    <td>Incentive</td>
                    <td class="amount">{{ number_format($salary->incentive_amount, 2) }}</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td>Attendance Bonus</td>
                    <td class="amount">{{ number_format($salary->attendance_bonus, 2) }}</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td><strong>Gross Salary</strong></td>
                    <td class="amount"><strong>{{ number_format($salary->gross_salary, 2) }}</strong></td>
                    <td><strong>Total Deductions</strong></td>
                    <td class="amount"><strong>{{ number_format($salary->pf + $salary->esi + $salary->pt + $salary->advance_deduction, 2) }}</strong></td>
                </tr>
                <tr class="net-pay">
                    <td colspan="2" style="text-align: right; border-right: none;">NET PAY:</td>
                    <td colspan="2" style="border-left: none;">₹ {{ number_format($salary->net_salary, 2) }}</td>
                </tr>
                <tr>
                    <td colspan="4" style="text-align: center; font-style: italic; font-size: 11px;">
                        Rupees {{ \NumberFormatter::create('en_IN', \NumberFormatter::SPELLOUT)->format($salary->net_salary) }} Only
                    </td>
                </tr>
            </tbody>
        </table>

        <div class="footer">
            <div class="signature">Employee Signature</div>
            <div class="signature">Director Signature</div>
        </div>
    </div>
</body>
</html>
