@extends('layouts.dashboard.managerapp')

@section('title', 'Edit Machine')

@section('content')
<!-- Page Heading -->
<div class="bg-white p-2 d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h5 mb-0 text-gray-800">UEPL / Edit Machine Details</h1>
    <div class="display-date">
        <span id="day">day</span>,
        <span id="daynum">00</span>
        <span id="month">month</span>
        <span id="year">0000</span>
    </div>
    <div class="display-time"></div>
</div>

@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif
@if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
@endif
@if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

<!-- Content Row -->
<div class="bg-white p-2 machine-form">
    <br>
    <h2>Edit Machine Details</h2>
    <br>
    <form id="machineForm" method="POST" action="{{ route('manager.machine.update', $machine->id) }}">
        @csrf
        <div class="row">
            <div class="col-md-6">
                <label for="machine_id">Machine ID <span class="required">*</span></label>
                <input type="text" id="machine_id" name="machine_id" value="{{ old('machine_id', $machine->machine_id) }}" required>
            </div>
            <div class="col-md-6">
                <label for="machine_name">Machine Name</label>
                <input type="text" id="machine_name" name="machine_name" value="{{ old('machine_name', $machine->machine_name) }}">
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label for="machine_sl_no">Machine SL No <span class="required">*</span></label>
                <input type="text" id="machine_sl_no" name="machine_sl_no" value="{{ old('machine_sl_no', $machine->machine_sl_no) }}" required>
            </div>
            <div class="col-md-6">
                <label for="make">Make</label>
                <input type="text" id="make" name="make" value="{{ old('make', $machine->make) }}">
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label for="model_type">Model Type</label>
                <input type="text" id="model_type" name="model_type" value="{{ old('model_type', $machine->model_type) }}">
            </div>
            <div class="col-md-6">
                <label for="diameter">Diameter (mm) <span class="required">*</span></label>
                <input type="number" id="diameter" name="diameter" step="0.01" value="{{ old('diameter', $machine->diameter) }}" required>
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-6">
                <label for="length">Length (m) <span class="required">*</span></label>
                <input type="number" id="length" name="length" step="0.01" value="{{ old('length', $machine->length) }}" required>
            </div>
            <div class="col-md-6">
                <label for="weight">Weight (kg) <span class="required">*</span></label>
                <input type="number" id="weight" name="weight" step="0.01" value="{{ old('weight', $machine->weight) }}" required>
            </div>
        </div><br>
        <div class="row">
            <div class="col-md-12">
                <label for="remarks">Remarks</label>
                <textarea id="remarks" name="remarks">{{ old('remarks', $machine->remarks) }}</textarea>
            </div>
        </div><br><br>
        <div class="row">
            <div class="col-md-3">
                <button class="btn btn-success" type="submit">Update</button>
            </div>
            <div class="col-md-3">
                <a href="{{ route('manager.machine.machinedetails') }}" class="btn btn-secondary">Back</a>
            </div>
        </div>
    </form>
</div>
@endsection
