@extends('layouts.dashboard.adminapp')

@section('title', 'Purchase Order Details')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <h1 class="mb-4">Purchase Order Details</h1>
        </div>
    </div>

    <!-- Back Button -->
    <div class="mb-4">
        <a href="{{ route('admin.purchase.purchasedetails') }}" class="btn btn-primary btn-sm">
            ← Back to Purchase Orders List
        </a>
    </div>

    <div class="row">
        <!-- Left Side: Purchase Order Header -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    Purchase Order Header
                </div>
                <div class="card-body">
                    <p><strong>Purchase Order No:</strong> {{ $po->purchase_order_no }}</p>
                    <p><strong>Date:</strong> {{ \Carbon\Carbon::parse($po->purchase_order_date)->format('d M Y') }}</p>
                    <p><strong>GRN No:</strong> {{ $po->grn_no ?? '-' }}</p>
                    <p><strong>Vendor Reference No:</strong> {{ $po->customer_ref_no ?? '-' }}</p>
                    <p><strong>Company Name (Vendor):</strong> {{ $po->company_name }}</p>
                    <p><strong>GSTN:</strong> {{ $po->company_gstn ?? '-' }}</p>
                    <p><strong>Phone:</strong> {{ $po->company_phone ?? '-' }}</p>
                    <p><strong>Email:</strong> {{ $po->company_email ?? '-' }}</p>
                    <p><strong>Quotation No:</strong> {{ $po->quotation_no ?? '-' }}</p>
                    <p><strong>Quotation Date:</strong> {{ $po->quotation_date ? \Carbon\Carbon::parse($po->quotation_date)->format('d M Y') : '-' }}</p>
                    <p><strong>RFQ No:</strong> {{ $po->rfq_no ?? '-' }}</p>
                    <p><strong>RFQ Date:</strong> {{ $po->rfq_date ? \Carbon\Carbon::parse($po->rfq_date)->format('d M Y') : '-' }}</p>
                    <p><strong>Part No:</strong> {{ $po->part_no ?? '-' }}</p>
                    <p><strong>Project Material No:</strong> {{ $po->project_material_no ?? '-' }}</p>
                    <p><strong>Drawing No:</strong> {{ $po->drawing_no ?? '-' }}</p>
                    <p><strong>Drawing Revision:</strong> {{ $po->drawing_rev ?? '-' }}</p>
                    <p><strong>Description:</strong> {{ $po->description ?? '-' }}</p>
                    <p><strong>Product Type:</strong> {{ $po->product_type ?? '-' }}</p>
                    <p><strong>Grand Total in Words:</strong> {{ $po->inr_in_words ?? '-' }}</p>
                    <p><strong>Subtotal:</strong> ₹{{ number_format($po->subtotal, 2) }}</p>
                    <p><strong>SGST Amount:</strong> ₹{{ number_format($po->sgst_amount, 2) }}</p>
                    <p><strong>CGST Amount:</strong> ₹{{ number_format($po->cgst_amount, 2) }}</p>
                    <p><strong>IGST Amount:</strong> ₹{{ number_format($po->igst_amount, 2) }}</p>
                    <p><strong>Round Up:</strong> ₹{{ number_format($po->round_up, 2) }}</p>
                    <p><strong>Grand Total:</strong> ₹{{ number_format($po->grand_total, 2) }}</p>
                </div>
            </div>
</div>
            <!-- Address Details -->
             <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-info text-white">
                    Address Details
                </div>
                <div class="card-body">
                    <p><strong>Bill To</strong><br>{{ $po->bill_address ?? '-' }}</p>
                    <p><strong>Ship To</strong><br>{{ $po->ship_address ?? '-' }}</p>
                </div>
            </div>
        </div>
</div>
        <!-- Right Side: Product Table -->
<div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="card-header bg-success text-white">
                    Product Details
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Sl No.</th>
                                    <th>Material Code</th>
                                    <th>HSN Code</th>
                                    <th>Description</th>
                                    <th>Additional Details</th>
                                    <th>Required By Date</th>
                                    <th>Quantity</th>
                                    <th>UOM</th>
                                    <th>Unit Rate</th>
                                    <th>Discount (%)</th>
                                    <th>Value (INR)</th>
                                    <th>SGST (%)</th>
                                    <th>CGST (%)</th>
                                    <th>IGST (%)</th>
                                    <th>Amount (INR)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($po->items as $item)
                                <tr>
                                    <td>{{ $item->sl_no }}</td>
                                    <td>{{ $item->material_code ?? '-' }}</td>
                                    <td>{{ $item->hsn_code ?? '-' }}</td>
                                    <td>{{ $item->material_description ?? '-' }}</td>
                                    <td>{{ $item->additional_details ?? '-' }}</td>
                                    <td>{{ $item->required_by_date ? \Carbon\Carbon::parse($item->required_by_date)->format('d M Y') : '-' }}</td>
                                    <td>{{ $item->quantity }}</td>
                                    <td>{{ $item->uom }}</td>
                                    <td>₹{{ number_format($item->unit_rate, 2) }}</td>
                                    <td>{{ $item->discount }}%</td>
                                    <td>₹{{ number_format($item->value, 2) }}</td>
                                    <td>{{ $item->sgst }}%</td>
                                    <td>{{ $item->cgst }}%</td>
                                    <td>{{ $item->igst }}%</td>
                                    <td>₹{{ number_format($item->amount, 2) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Ensure tables are scrollable if they overflow
    $('.table-responsive').each(function() {
        var table = $(this).find('table');
        if (table.width() > $(this).width()) {
            $(this).css('overflow-x', 'auto');
        }
    });
});
</script>
@endsection