<!DOCTYPE html>
<html>
<head>
    <title>Tax Invoice - {{ $invoice->invoice_no }}</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap');
        body {
            font-family: 'Roboto', Arial, sans-serif;
            margin: 0;
            padding: 0;
            background: #f5f6fa; /* Light, neutral background */
            color: #222b45;
        }
        .invoice-box {
            max-width: 1100px;
            margin: 40px auto;
            background: #fff;
            box-shadow: 0 4px 24px 4px #e2e6ea;
            border-radius: 14px;
            padding: 40px 50px 40px 50px;
            min-height: 950px;
        }
        .header {
            display: flex;
            align-items: center;
            border-bottom: 4px solid #1976d2;
            padding-bottom: 12px;
        }
        .header-logo img {
            height: 72px;
            width: auto;
        }
        .header-company {
            margin-left: 30px;
        }
        .header-company h2 {
            margin: 0;
            color: #1976d2;
            font-size: 2.2rem;
            font-weight: 700;
        }
        .header-company .company-info {
            font-weight: 400;
            color: #555;
            font-size: 1.06rem;
        }
        h3 {
            color: #1565c0;
            margin-top: 36px;
            margin-bottom: 15px;
            font-weight: 700;
        }
        table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            margin-top: 15px;
            font-size: 1.03rem;
        }
        th, td {
            border: 1px solid #b2bec3;
            padding: 10px 8px;
        }
        th {
            background: #1976d2;
            color: #fff;
            font-weight: 700;
            text-align: center;
        }
        .no-border {
            border: none !important;
        }
        .text-right {
            text-align: right !important;
        }
        .text-center {
            text-align: center !important;
        }
        .section-title {
            font-size: 1.07rem;
            color: #1976d2;
            font-weight: 600;
            background: #e3f0fb;
            padding: 7px 12px;
            border-radius: 6px;
            margin-bottom: 2px;
        }
        .signature {
            margin-top: 64px;
            font-size: 1.08rem;
        }
        .signature-box {
            float: right;
            text-align: center;
            padding: 20px 32px 6px 32px;
            border-top: 2px solid #1976d2;
            background: #f5fafd;
            border-radius: 10px 10px 0 0;
        }
        .declaration {
            margin-top: 28px;
            background: #f5fafd;
            border-left: 6px solid #1976d2;
            padding: 11px 20px;
            font-size: 1.03rem;
        }
        .print-btn {
            display: block;
            margin: 48px auto 0 auto;
            background: #1976d2;
            color: #fff;
            padding: 12px 46px;
            border: none;
            border-radius: 28px;
            font-size: 1.07rem;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s;
            box-shadow: 0 4px 16px rgba(25,118,210,0.10);
        }
        .print-btn:hover {
            background: #1258a5;
        }
        /* Landscape print */
        @media print {
            @page { size: A4 landscape; margin: 18mm 10mm; }
            .print-btn, .no-print { display: none !important; }
            body { background: none !important; }
            .invoice-box {
                box-shadow: none !important;
                margin: 0 !important;
                min-height: unset;
                border-radius: 0 !important;
            }
        }
    </style>
</head>
<body>
    <div class="invoice-box">
        <!-- Header with logo and company info -->
        <div class="header">
            <div class="header-logo">
                <img src="{{ asset('cbimage.png') }}" alt="Company Logo">
            </div>
            <div class="header-company">
                <h2>UMBREY ENGINEERING PVT LTD</h2>
                <div class="company-info">
                    No. 31, 2nd Phase, Peenya Industrial Area, Bengaluru 560 058, Karnataka, India<br>
                    GSTN: 29AAACU2461N1ZY &nbsp;|&nbsp; PAN: AAACU2461N
                </div>
            </div>
        </div>

        <h3>Tax Invoice</h3>

        <table>
            <tr>
                <td><strong>Invoice No:</strong> {{ $invoice->invoice_no }}</td>
                <td><strong>Invoice Date:</strong> {{ \Carbon\Carbon::parse($invoice->invoice_date)->format('d-m-Y') }}</td>
            </tr>
            <tr>
                <td><strong>Reference No:</strong> {{ $invoice->reference_no }}</td>
                <td><strong>Reference Date:</strong> {{ $invoice->reference_date ? \Carbon\Carbon::parse($invoice->reference_date)->format('d-m-Y') : '-' }}</td>
            </tr>
        </table>

        <table style="margin-top: 20px;">
            <tr>
                <th style="width:47%;">Buyer (Bill to)</th>
                <th>Shipping (if different)</th>
            </tr>
            <tr>
                <td>
                    <strong>{{ $invoice->company->company ?? '' }}</strong><br>
                    {{ $invoice->address }}<br>
                    GST No: {{ $invoice->company->gstno ?? '' }}<br>
                    Email: {{ $invoice->company->email ?? '' }}<br>
                    Phone: {{ $invoice->company->mobile ?? '' }}
                </td>
                <td>
                    {{ $invoice->address }}<br>
                </td>
            </tr>
        </table>

        <div class="section-title" style="margin-top: 26px;">Invoice Details</div>
        <table>
            <thead>
                <tr>
                    <th>Sl. No</th>
                    <th>Description of Goods</th>
                    <th>HSN/SAC</th>
                    <th>Qty</th>
                    <th>Rate</th>
                    <th>Per</th>
                    <th>SGST (%)</th>
                    <th>CGST (%)</th>
                    <th>IGST (%)</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody>
            @foreach($invoice->items as $i => $item)
                <tr>
                    <td class="text-right">{{ $i+1 }}</td>
                    <td>{{ $item->description }}</td>
                    <td class="text-center">{{ $item->hsn }}</td>
                    <td class="text-right">{{ $item->quantity }}</td>
                    <td class="text-right">{{ number_format($item->rate, 2) }}</td>
                    <td class="text-center">{{ $item->per }}</td>
                    <td class="text-right">{{ $item->sgst }}</td>
                    <td class="text-right">{{ $item->cgst }}</td>
                    <td class="text-right">{{ $item->igst }}</td>
                    <td class="text-right">{{ number_format($item->amount, 2) }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>

        <table style="margin-top:22px; width: 55%; float:right;">
            <tr>
                <td class="no-border text-right"><strong>Taxable Value:</strong></td>
                <td class="no-border text-right" style="width: 130px;">{{ number_format($invoice->taxable_value, 2) }}</td>
            </tr>
            <tr>
                <td class="no-border text-right"><strong>SGST:</strong></td>
                <td class="no-border text-right">{{ number_format($invoice->sgst, 2) }}</td>
            </tr>
            <tr>
                <td class="no-border text-right"><strong>CGST:</strong></td>
                <td class="no-border text-right">{{ number_format($invoice->cgst, 2) }}</td>
            </tr>
            <tr>
                <td class="no-border text-right"><strong>IGST:</strong></td>
                <td class="no-border text-right">{{ number_format($invoice->igst, 2) }}</td>
            </tr>
            <tr>
                <td class="no-border text-right"><strong>Total Tax Amount:</strong></td>
                <td class="no-border text-right">{{ number_format($invoice->total_tax_amount, 2) }}</td>
            </tr>
            <tr>
                <td class="no-border text-right"><strong>Total Amount:</strong></td>
                <td class="no-border text-right">{{ number_format($invoice->total_amount, 2) }}</td>
            </tr>
            <tr>
                <td class="no-border text-right"><strong>Amount in Words:</strong></td>
                <td class="no-border text-right">{{ $invoice->amount_in_words }}</td>
            </tr>
        </table>
        <div style="clear: both;"></div>

        <div class="declaration">
            <strong>Declaration:</strong>
            <div>
                We declare that this invoice shows the actual price of the goods described and that all particulars are true and correct.
            </div>
        </div>

        <div class="signature">
            <div class="signature-box">
                For <strong>Umbrey Engineering PVT LTD</strong><br><br>
                Authorised Signatory
            </div>
        </div>
        <div style="clear: both"></div>
        <button class="print-btn no-print" onclick="window.print()">Print Invoice</button>
    </div>
</body>
</html>
