@extends('layouts.dashboard.adminapp')

@section('title', 'Customer/Vendor List')

@section('styles')
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">
    <style>
        .dataTable {
            display: revert !important;
        }
        .dt-buttons .btn {
            margin-right: 0.5rem !important;
            padding: 0.25rem 0.75rem !important;
            font-size: 0.95rem !important;
        }
        .card {
            border-radius: 16px !important;
            box-shadow: 0 6px 32px 0 rgba(44,62,80,0.07), 0 1.5px 4px 0 rgba(44,62,80,0.03) !important;
        }
        .custom-page-title {
            font-size: 2.2rem;
            font-weight: 600;
            color: #444;
            letter-spacing: .5px;
            margin-bottom: 1rem;
            text-align: center;
        }
        .custom-page-title i {
            font-size: 2.6rem;
            color: #5a8dee;
            margin-right: 10px;
            vertical-align: middle;
        }
        .add-customer-btn {
            min-width: 180px;
            font-weight: 500;
            font-size: 1.07rem;
        }
        .badge {
            font-size: 0.95em;
            padding: 5px 12px;
            border-radius: 12px;
        }
        .btn-info, .btn-warning, .btn-danger {
            min-width: 62px;
            font-weight: 500;
            font-size: 0.97rem;
        }
        .btn-danger {
            min-width: 80px;
        }
        th, td {
            vertical-align: middle !important;
        }
        .table-responsive {
            overflow-x: auto;
        }
    </style>
@endsection

@section('content')
<div class="container-fluid bg-white py-3" style="border-radius: 18px;">
    <!-- Header Bar with date/time and Add button -->
    <div class="d-flex align-items-center justify-content-between mb-2">
        <div>Customer & Vendor List</div>
        <div class="display-date text-center">
            <span id="day">day</span>,
            <span id="daynum">00</span>
            <span id="month">month</span>
            <span id="year">0000</span>
        </div>
        <div class="display-time text-end"></div>
    </div>

    <hr class="my-2">

    <!-- Centered title/icon -->
    

    <!-- Add Customer Button -->
    <div class="d-flex justify-content-end mb-3">
        
        <a href="{{ route('admin.addcustomer') }}" class="btn btn-primary add-customer-btn">
            <i class="fas fa-user-plus me-1"></i> Add New Customer
        </a>
    </div>

    <!-- Card with DataTable -->
    <div class="card mb-5">
        <div class="card-header d-flex align-items-center" style="font-size: 1.15rem; font-weight: 500;">
            <i class="fas fa-table me-2"></i> Customer & Vendor List
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered align-middle" id="customerTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Company Name</th>
                            <th>Email</th>
                            <th>Contact Number</th>
                            <th>Status</th>
                            <th style="min-width: 160px;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($customers as $customer)
                        <tr id="row-{{ $customer->id }}">
                            <td>{{ $customer->id }}</td>
                            <td><strong>{{ $customer->company }}</strong></td>
                            <td>{{ $customer->email }}</td>
                            <td>{{ $customer->mobile }}</td>
                            <td>
                                @if($customer->status == 1)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-secondary">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('customer.show', $customer->id) }}" class="btn btn-info btn-sm me-1">View</a>
                                <a href="{{ route('customer.edit', $customer->id) }}" class="btn btn-warning btn-sm me-1">Edit</a>
                                <button class="btn btn-danger btn-sm delete-btn" data-id="{{ $customer->id }}">Delete</button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
<script>
$(document).ready(function() {
    // DataTable
    var table = $('#customerTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            { extend: 'copy', className: 'btn btn-secondary btn-sm' },
            { extend: 'csv', className: 'btn btn-secondary btn-sm' },
            { extend: 'excel', className: 'btn btn-secondary btn-sm' },
            { extend: 'pdf', className: 'btn btn-secondary btn-sm' },
            { extend: 'print', className: 'btn btn-secondary btn-sm' },
            { extend: 'colvis', className: 'btn btn-secondary btn-sm' }
        ],
        pageLength: 10,
        responsive: true,
        language: { "emptyTable": "No customers found" }
    });

    // AJAX Delete
    $(document).on('click', '.delete-btn', function() {
        var id = $(this).data('id');
        if (confirm('Are you sure you want to delete this customer?')) {
            $.ajax({
                url: '/admin/customers/' + id,
                type: 'DELETE',
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    table.row('#row-' + id).remove().draw(false);
                    toastr.success('Customer deleted successfully!');
                },
                error: function(xhr) {
                    toastr.error('Could not delete customer.');
                }
            });
        }
    });
});
</script>
@endsection
