<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RouteCardProcess extends Model
{
    use HasFactory;

    protected $table = 'route_card_processes';

    protected $fillable = [
        'route_card_id',
        'process',
        'machine',
        'operator',
        'cycle_hours',
        'cycle_minutes',
        'source',
        'description',
        'start_date',
        'end_date',
        'previous_process_id',
    ];

    public function previousProcess()
    {
        return $this->belongsTo(RouteCardProcess::class, 'previous_process_id');
    }

    public function attchedMachine() {
        return $this->belongsTo(Machines::class, 'machine', 'id');
    }

    public function attchedProcess()
    {
        return $this->belongsTo(Process::class, 'process', 'name');
    }

    public function attchedOperator() {
        return $this->belongsTo(EmployeeDetails::class, 'operator', 'id');
    }

    public function routeCard()
    {
        return $this->belongsTo(RouteCard::class, 'route_card_id');
    }

    public function qcApprovals()
    {
        return $this->hasMany(QcApproval::class, 'process_id');
    }
    
    public function operatorUser()
    {
        return $this->belongsTo(EmployeeDetails::class, 'operator');
    }
}
