<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Rfq extends Model
{
    use HasFactory;

    protected $fillable = [
        'rfq_no',
        'rfq_date',
        'customer',
        'cus_ref_no',
        'rfq_type',
        'product_type',
        'part_no',
        'project_material_no',
        'description',
        'drawing_no',
        'drawing_rev',
        'quantity',
        'uom',
        'note',
        'raw_material',
    ];

    public function customerInfo()
    {
        return $this->belongsTo(\App\Models\CustomerVendor::class, 'customer', 'id');
        // or 'customer_id' if that's your field
    }
    
    public function rfqFiles()
    {
        return $this->hasMany(RfqFile::class);
    }
}
