<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseRFQItem extends Model
{
    use HasFactory;

    protected $table = 'purchase_rfq_items';

    protected $fillable = [
        'rfq_id', 'item', 'description', 'quantity', 'uom', 'required_by'
    ];

    public function rfq()
    {
        return $this->belongsTo(PurchaseRFQ::class);
    }
    public function stockItem()
    {
        return $this->belongsTo(StockItem::class, 'item', 'id');
    }
}
