<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseOrder extends Model
{
    use HasFactory;

    // Fillable fields for the purchase order form data
    protected $fillable = [
        'purchase_order_no',
        'purchase_order_date',
        'grn_no',
        'quotation_no',
        'quotation_date',
        'customer_ref_no',
        'company_name',
        'vendor_id',
        'company_address',
        'company_gstn',
        'company_phone',
        'company_email',
        'bill_address',
        'ship_address',
        'product_type',
        'inr_in_words',
        'subtotal',
        'sgst_amount',
        'cgst_amount',
        'igst_amount',
        'round_up',
        'grand_total',
        'rfq_no',
        'rfq_date',
        'description',
        'delivery_terms',
        'additional_charges',
        'note',
        'vendor_po_file_path',
    ];

    // Relationship to items (purchase order items)
    public function items()
    {
        return $this->hasMany(PurchaseOrderItem::class);
    }
    
     public function quotation()
    {
        return $this->belongsTo(\App\Models\PurchaseQuotation::class, 'quotation_no', 'quotation_no');
    }
    
    public function vendor()
    {
        return $this->belongsTo(\App\Models\CustomerVendor::class, 'vendor_id', 'id');
    }
    
    public function purchase()
    {
        return $this->hasOne(Purchase::class, 'purchase_order_no', 'purchase_order_no');
    }
}
