<?php

// app/Models/EmployeeSalaryDetail.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class EmployeeSalaryDetail extends Model
{
    protected $fillable = [
        'employee_id',
        'month_year',
        'basic_da',
        'hra',
        'conveyance',
        'washing_allowance',
        'fixed_salary',
        'no_of_days_worked',
        'leave_given',
        'total_days_for_salary',
        'drawn_salary',
        'incentive_hrs',
        'incentive_rate',
        'incentive_amount',
        'attendance_bonus',
        'gross_salary',
        'esi',
        'pf',
        'pt',
        'advance_deduction',
        'net_salary',
        'payment_mode'
    ];

    public function employee()
    {
        return $this->belongsTo(EmployeeDetails::class);
    }
}
