<?php

namespace App\Http\Controllers\Manager;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\RawMaterial;

class ManagerRawMaterialController extends Controller
{
    public function index()
    {
        return view('manager.master.rawmaterials');
    }

    public function list()
    {
        $materials = RawMaterial::select('id', 'name', 'iso_specification', 'density', 'mechanical_properties', 'chemical_properties')->get();
        return response()->json(['data' => $materials]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'density' => 'required',
        ]);

        RawMaterial::create([
            'name' => $request->name,
            'iso_specification' => $request->iso_specification,
            'density' => $request->density,
            'mechanical_properties' => $request->mechanical_properties,
            'chemical_properties' => $request->chemical_properties,
        ]);

        return response()->json(['success' => true, 'message' => 'Raw Material added']);
    }
    public function show(RawMaterial $rawmaterial)
    {
        return response()->json($rawmaterial);
    }

    public function update(Request $request, RawMaterial $rawmaterial)
    {
        $request->validate([
            'name' => 'required',
            'density' => 'required',
        ]);

        $rawmaterial->update([
            'name' => $request->name,
            'iso_specification' => $request->iso_specification,
            'density' => $request->density,
            'mechanical_properties' => $request->mechanical_properties,
            'chemical_properties' => $request->chemical_properties,
        ]);

        return response()->json(['success' => true, 'message' => 'Raw Material updated']);
    }

    public function delete(RawMaterial $rawmaterial)
    {
        $rawmaterial->delete();
        return response()->json(['success' => true, 'message' => 'Raw Material deleted']);
    }
}
