<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\EmployeeAttendance;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Illuminate\Support\Facades\Log;

class EmployeeAttendanceController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $data = EmployeeAttendance::all();
        return view('admin.employee.employeeattendance', compact('data'));
    }

    public function import(Request $request)
    {
        $file = $request->file('import_file');
        $spreadsheet = IOFactory::load($file);
        $sheetData = $spreadsheet->getActiveSheet()->toArray(null, true, true, true);

        foreach (array_slice($sheetData, 1) as $row) {
            EmployeeAttendance::create([
                'employee_name' => $row['A'],
                'employee_id' => $row['B'],
                'gender' => $row['C'],
                'date_of_birth' => $row['D'],
                'date_of_joining' => $row['E'],
                'department' => $row['F'],
                'designation' => $row['G'],
                'days_worked' => $row['H'],
                'sundays_eligible' => $row['I'],
                'holidays' => $row['J'],
                'leave_enjoyed' => $row['K'],
                'total_paid_days' => $row['L'],
                'absent' => $row['M'],
                'first_shifts' => $row['N'],
                'night_shifts' => $row['O'],
                'ot_hours' => $row['P'],
                'shortage_hours' => $row['Q'],
            ]);
        }

        return back()->with('success', 'Attendance imported successfully!');
    }

    public function store(Request $request)
    {
        Log::info('Storing employee attendance data', $request->all());
        EmployeeAttendance::create($request->all());
        return back()->with('success', 'Record added!');
    }

    public function edit($id)
    {
        return response()->json(EmployeeAttendance::find($id));
    }

    public function update(Request $request, $id)
    {
        Log::info("Updating employee attendance", $request->all());

        $validated = $request->validate([
            'employee_name' => 'required|string|max:255',
            'employee_id' => 'required|string|max:100',
            'gender' => 'required|in:Male,Female,Other',
            'date_of_birth' => 'required|date',
            'date_of_joining' => 'required|date',
            'department' => 'required|string|max:255',
            'designation' => 'required|string|max:255',
            'days_worked' => 'required|integer',
            'sundays_eligible' => 'required|integer',
            'holidays' => 'required|integer',
            'leave_enjoyed' => 'required|integer',
            'total_paid_days' => 'required|integer',
            'absent' => 'required|integer',
            'first_shifts' => 'required|integer',
            'night_shifts' => 'required|integer',
            'ot_hours' => 'required|integer',
            'shortage_hours' => 'required|integer',
        ]);

        $attendance = EmployeeAttendance::findOrFail($id);
        $attendance->update($validated);

        return response()->json(['success' => true]);
    }


    public function destroy($id)
    {
        EmployeeAttendance::find($id)->delete();
        return response()->json(['success' => true]);
    }
}
