@push('scripts')
<script>
    $(document).ready(function() {

        // Add purchase invoice button - Open modal
        $('#addPurchaseInvoiceBtn').on('click', function() {
            $('#purchaseInvoiceForm')[0].reset();
            $('#purchaseInvoiceForm').removeData('edit-id');
            $('#purchaseInvoiceForm').removeData('edit-row');
            $('#modalTitle').text('Add New Purchase Invoice');
            $('#purchaseInvoiceModal').modal('show');
        });

        // View purchase invoice details
        $(document).on('click', '.view-purchase-invoice', function() {
            let id = $(this).data('id');
            $('#viewPurchaseInvoiceBody').html(
                '<div class="text-center"><i class="fas fa-spinner fa-spin"></i> Loading...</div>'
            );
            $('#viewPurchaseInvoiceModal').modal('show');
        });

        // Delete purchase invoice
        $(document).on('click', '.delete-purchase-invoice', function() {
            let id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: "You want to delete this purchase invoice!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Yes, Delete!',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{ url("/superadmin/purchase/destroy") }}/' + id,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}',
                            _method: 'DELETE'
                        },
                        success: function(response) {
                            Swal.fire('Deleted!', 'Purchase Invoice deleted successfully.', 'success');
                            location.reload();
                        },
                        error: function(xhr) {
                            Swal.fire('Error', 'Error occurred while deleting.', 'error');
                            console.error(xhr.responseText);
                        }
                    });
                }
            });
        });

    });
</script>
@endpush
